﻿using System;

namespace ArrayMembers
{
    class Program
    {
        static void Main(string[] args)
        {
            CalendarEvent[] events =
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            LoopFind(events);
            FindAll(events);
            SortEvents(events);

            // Listing 7-16. Sortowanie danych posiadających naturalne uporządkowanie.
            int[] numbers = { 4, 1, 2, 5, 3 };
            Array.Sort(numbers);
        }

        static void LoopFind(CalendarEvent[] events)
        {
            // Listing 7-13. Odnajdywanie elementu tablicy z wykorzystaniem pętli.
            DateTime dateOfInterest = new DateTime(2009, 7, 12);
            foreach (CalendarEvent item in events)
            {
                if (item.StartTime.Date == dateOfInterest)
                {
                    Console.WriteLine(item.Title + ": " + item.StartTime);
                }
            }

            Console.WriteLine();
        }

        static void FindAll(CalendarEvent[] events)
        {
            // Listing 7-14. Wyszukiwanie elementów przy użyciu metody FindAll
            DateTime dateOfInterest = new DateTime(2009, 7, 12);
            CalendarEvent[] itemsOnDateOfInterest = Array.FindAll(events,
            e => e.StartTime.Date == dateOfInterest);
            foreach (CalendarEvent item in itemsOnDateOfInterest)
            {
                Console.WriteLine(item.Title + ": " + item.StartTime);
            }

            Console.WriteLine();
        }

        static void SortEvents(CalendarEvent[] events)
        {
            // Listing 7-15. Sortowanie tablicy.
            Array.Sort(events,
                (event1, event2) => event1.StartTime.CompareTo(event2.StartTime));

            PrintEvents(events);
            Console.WriteLine();

            Array.Sort(events,
                (event1, event2) => event1.Duration.CompareTo(event2.Duration));
            PrintEvents(events);
            Console.WriteLine();
        }

        static void PrintEvents(CalendarEvent[] events)
        {
            foreach (CalendarEvent item in events)
            {
                Console.WriteLine(item.Title + ": " + item.StartTime);
            }
        }
    }
}
